/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.server;

import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.server.RxRequest;
import com.ibm.hsc.rep.server.RxResponse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Hashtable;

public class RxWorker
extends Thread {
    private Socket m_socket;

    public RxWorker(Socket socket) {
        this.m_socket = socket;
    }

    public void run() {
        System.out.println("RxWorker: socket=" + this.m_socket);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.m_socket.getOutputStream());
            ObjectInputStream objectInputStream = new ObjectInputStream(this.m_socket.getInputStream());
            while (true) {
                Serializable serializable;
                RxRequest rxRequest = (RxRequest)objectInputStream.readObject();
                System.out.println("Client RxRequest: " + rxRequest);
                int n = rxRequest.getQueryType();
                int n2 = rxRequest.getNameSpaceId();
                RObjectId rObjectId = null;
                Object object = null;
                switch (n) {
                    case 0: 
                    case 1: {
                        int n3 = rxRequest.getClassId();
                        Hashtable hashtable = rxRequest.getPropHash();
                        object = RUtils.queryMatched(n, n2, n3, hashtable);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        int n4 = rxRequest.getAssoId();
                        rObjectId = rxRequest.getObjectId();
                        object = RUtils.queryRefs(n, n2, n4, rObjectId);
                        break;
                    }
                    case 4: {
                        rObjectId = rxRequest.getObjectId();
                        if (rObjectId == null) break;
                        object = rObjectId.getObject();
                        break;
                    }
                    case 5: {
                        rObjectId = rxRequest.getObjectId();
                        String string = rxRequest.getPropName();
                        if (rObjectId == null || string == null || (serializable = rObjectId.getObject()) == null) break;
                        object = ((RObject)serializable).getProperty(string);
                    }
                }
                serializable = new RxResponse();
                ((RxResponse)serializable).setRetVal(n, object);
                ((RxResponse)serializable).setSeqNum(rxRequest.getSeqNum());
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
                System.err.println("Request handled");
            }
        }
        catch (Exception exception) {
            System.err.println("RxWorker: -");
            try {
                this.m_socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println(iOException);
            }
            System.err.println("RxWorker: finished.");
            return;
        }
    }
}

